#!/bin/sh

# Source debconf library.
. /usr/share/debconf/confmodule
db_version 2.0
db_get libdvdcss-pkg/build

PKGI="libdvdcss-pkg"
DIR="/usr/src/${PKGI}"
PKGG="libdvdcss2"
PKGG_ALL="libdvdcss2 libdvdcss-dev"

## $RET contains "true" if build is allowed in debconf.
if [ "$RET" = "true" ]; then
    ## get installed installer-package version
    VER="$(dpkg --status ${PKGI} 2>/dev/null | perl -0ne 'print $1 if m{Version:\s+([a-zA-Z0-9.~+-]+)}sm;')"

    ## get installed guest-package version
    VERG="$(dpkg --status ${PKGG} 2>/dev/null | perl -0ne 'print $1 if m{^Status:\s+install\s+ok\s+installed}sm and m{^Version:\s+([a-zA-Z0-9.~+-]+)}sm;')"

    ## get to-be installed guest-package version (replace first '+'): 1.2.3+1more+fud1 -> 1.2.3-1more+fud1~local
    PKGG_VER="$(printf "${VER}" | sed 's/\+/-/')~local"

    ## check if our version of guest package is installed.
    ## installer and guest packages versions are expected to match so
    ## installer-package version is mangled to append '~local' to debian revision number
    dpkg --compare-versions "${PKGG_VER}" gt "${VERG}"
    if [ $? = 0 ]; then

        ## we have newer package to build/install

        ## Check if this very version of guest package was previously installed.
        ## self-disable in debconf settings, if user manually removed it.
        if [ -f "${DIR}/${PKGG}-${VER}.is-installed" ]; then
            rm "${DIR}/${PKGG}-${VER}.is-installed"
            db_set ${PKGI}/build false
            echo "${PKGI}: Package ${PKGG}-${VER} was removed, stop processing..."
            exit 0
        fi

        ## check if DPKG database is locked
        dpkg -i /dev/zero 2>/dev/null
        if [ "$?" -eq 2 ]; then
            echo "${PKGI}: dpkg database is locked. Package(s) will be built and installed by dpkg post-invoke handler."
            echo "${PKGI}: post-invoke handler will take control after next apt-get operation i.e. install/remove/upgrade etc."
            echo "${PKGI}: Alternatively you may use command \"sudo dpkg-reconfigure ${PKGI}\"."
            exit 0
        fi

        set -e
        mkdir -p ${DIR} || true

        ## download orig.tar
        echo "${PKGI}: Downloading orig source..."
        cd ${DIR} \
        && /usr/share/${PKGI}/debian/rules get-orig-source
        echo "${PKGI}: Checking integrity..."
        md5sum --check --status --quiet /usr/share/${PKGI}/*_${PKGG_VER%%-*}.orig.tar.*.md5

        ## preparing to build
        echo "${PKGI}: Unpacking and configuring..."
        [ -d "${DIR}/build" ] && rm -rf ${DIR}/build
        mkdir ${DIR}/build
        cd ${DIR}/build
        tar xf ../*_${PKGG_VER%%-*}.orig.tar.* --strip-components 1
        cp -r /usr/share/${PKGI}/debian .
        ## append '~local' to debian revision
        #perl -pi -e "s{[\d.]+-[\d~+a-zA-Z]+\K}{~local}" debian/changelog
        ## inject ${PKGI} to guest package Depends to uninstall generated packages on installer remove.
        perl -pi -e "s{^Depends:\K}{ ${PKGI}, }mg" debian/control

        ## building package
        echo "${PKGI}: Building the package..."
        dpkg-buildpackage -b -uc

        ## installing
        echo "${PKGI}: Installing..."
        dpkg --install /usr/src/${PKGI}/*_${PKGG_VER}_*.deb \
        && touch "${DIR}/${PKGG}-${VER}.is-installed" \
        || echo "${PKGI}: dpkg database is probably locked. Installation will be performed later from dpkg post-invoke handler."
    fi
fi


